/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.mysql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import jtbcore.db.common.SqlConnection;
import jtbcore.db.model.DatabaseModel;
import jtbcore.db.model.TableModel;
import jtbcore.db.mysql.MysqlTableModelGenerator;
import jtbcore.db.sql.SqlDatabase;
import jtbcore.db.sql.SqlTable;
import jtbcore.exception.InvalidStateException;

public class MysqlConnection
extends SqlConnection {
    protected Boolean integratedSecurity = false;
    protected String host;
    protected String username;
    protected String password;
    protected String databaseName;
    protected SqlDatabase sqlDb = null;
    protected Boolean autoReconnect = true;

    public Boolean getIntegratedSecurity() {
        return this.integratedSecurity;
    }

    public void setIntegratedSecurity(Boolean integratedSecurity) {
        this.integratedSecurity = integratedSecurity;
    }

    public String getHost() {
        if (this.host == null || this.host.trim().length() == 0) {
            return "localhost";
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Boolean getAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(Boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    @Override
    public void connect() throws SQLException, InvalidStateException {
        Connection con = null;
        if (this.integratedSecurity.booleanValue()) {
            String host = this.host == null ? "" : this.host;
            String url = "jdbc:mysql://" + host + "/" + this.databaseName + "?autoReconnect=true&socket=/var/run/mysqld/mysqld.sock";
            con = DriverManager.getConnection(url);
        } else {
            String host = this.host == null ? "" : this.host;
            String url = "jdbc:mysql://" + host + "/" + this.databaseName;
            if (this.autoReconnect.booleanValue()) {
                url = url + "?autoReconnect=true";
            }
            con = DriverManager.getConnection(url, this.username, this.password);
        }
        this.connection = con;
    }

    @Override
    public void updateTable(TableModel t) throws SQLException, IOException {
        DatabaseModel model = new DatabaseModel();
        t.setAutogenerated(true);
        model.addTable(t);
        MysqlTableModelGenerator modgen = new MysqlTableModelGenerator(model);
        List<TableModel> updatedTables = modgen.updateSchema(this);
        if (updatedTables.size() > 0 && this.sqlDb != null) {
            for (TableModel tm : updatedTables) {
                SqlTable qt = modgen.mysqlToSqlTable(this, tm.getName());
                this.sqlDb.addTable(qt);
            }
        }
    }

    @Override
    public SqlDatabase getSqlDatabase() throws IOException, SQLException {
        if (this.sqlDb == null) {
            MysqlTableModelGenerator gen = new MysqlTableModelGenerator();
            this.sqlDb = gen.mysqlToSqlDatabase(this);
        }
        return this.sqlDb;
    }

    @Override
    public void resetSqlDatabase() {
        this.sqlDb = null;
    }

    @Override
    public Integer insertQuery(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = super._insertQuery(sql, args);
        ps.close();
        return this.queryInteger("select last_insert_id()", new Object[0]);
    }

    @Override
    public void initModel(DatabaseModel model) throws SQLException, IOException {
        MysqlTableModelGenerator modgen = new MysqlTableModelGenerator(model);
        List<TableModel> updatedTables = modgen.updateSchema(this);
        if (updatedTables.size() > 0) {
            this.sqlDb = null;
        }
    }

    public void ping() {
        try {
            this.query("select 1", new Object[0]);
        }
        catch (Exception e) {
            System.out.println("MySQL PING Failed: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            Object test = null;
            System.out.println("Test: " + String.valueOf(test));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

